/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessStatusEvent;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;

public class VWUDDIBusinessContactsTableModel
extends AbstractTableModel {
    protected static final int COLUMN_ID = 0;
    protected static final int COLUMN_NAME = 1;
    protected static final int COLUMN_TYPE = 2;
    protected static final int COLUMN_DESCRIPTION = 3;
    protected String[] m_columnNames = new String[]{"", VWResource.s_name, VWResource.s_type, VWResource.s_description};
    protected Frame m_parentFrame = null;
    protected String m_dialogTitle = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private Contacts m_contacts = null;
    private boolean m_bCellEditable = true;
    private EventListenerList m_listenerList = null;
    private VWUDDIBusinessItem m_vwBusinessItem = null;

    public VWUDDIBusinessContactsTableModel(Frame parent, Contacts contactList) {
        this.init(parent, contactList);
    }

    public VWUDDIBusinessContactsTableModel(Frame parent, VWUDDIBusinessItem businessItem) {
        try {
            Contacts contactList = null;
            this.m_vwBusinessItem = businessItem;
            if (this.m_vwBusinessItem != null) {
                contactList = businessItem.getContacts();
            }
            this.init(parent, contactList);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void init(Frame parent, Contacts contactList) {
        try {
            this.m_parentFrame = parent;
            this.m_rowData = new Vector();
            this.m_contacts = contactList;
            this.m_listenerList = new EventListenerList();
            if (this.m_contacts != null) {
                Vector contactVector = this.m_contacts.getContactVector();
                int sz = contactVector.size();
                for (int i = 0; i < sz; ++i) {
                    this.m_rowData.add(contactVector.elementAt(i));
                }
            }
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addBusinessStatusListener(IVWUDDIBusinessStatusListener listener) {
        this.m_listenerList.add(IVWUDDIBusinessStatusListener.class, listener);
    }

    public void setVWBusinessItem(VWUDDIBusinessItem businessItem) {
        try {
            this.m_vwBusinessItem = businessItem;
            if (this.m_vwBusinessItem != null) {
                this.m_contacts = this.m_vwBusinessItem.getContacts();
                this.m_rowData = this.m_contacts != null ? this.m_contacts.getContactVector() : null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Contact[] getContacts() {
        Object[] theList = new Contact[this.m_rowData.size()];
        this.m_rowData.copyInto(theList);
        return theList;
    }

    public Vector getContactVector() {
        return this.m_rowData;
    }

    public void setContactVector(Vector data) {
        if (data == null) {
            this.m_rowData.removeAllElements();
        } else {
            this.m_rowData = data;
        }
        this.fireTableDataChanged();
    }

    public Contact getContact(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.m_rowData.size()) {
            return null;
        }
        return (Contact)this.m_rowData.elementAt(rowIndex);
    }

    public void setContact(Contact theContact, int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.m_rowData.size() || theContact == null) {
            return;
        }
        this.m_rowData.setElementAt(theContact, rowIndex);
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            this.m_rowData.addElement(new Contact());
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
            if (this.m_vwBusinessItem != null) {
                this.m_vwBusinessItem.setModified(this.m_bHasChanged);
            }
            this.BusinessChanged(1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn > this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null || nRowIndex >= this.m_rowData.size()) {
                return null;
            }
            Contact oContact = (Contact)this.m_rowData.elementAt(nRowIndex);
            if (oContact == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return String.valueOf(nRowIndex + 1);
                }
                case 1: {
                    PersonName oPersonName = oContact.getPersonName();
                    if (oPersonName == null) {
                        return "";
                    }
                    return oPersonName.getValue();
                }
                case 2: {
                    String userType = oContact.getUseType();
                    if (userType == null) {
                        userType = "";
                    }
                    return userType;
                }
                case 3: {
                    String description = null;
                    Vector v = oContact.getDescriptionVector();
                    if (v != null && v.size() > 0 && v.elementAt(0) != null && v.elementAt(0) instanceof Description) {
                        description = ((Description)v.elementAt(0)).getValue();
                    }
                    if (description == null) {
                        description = "";
                    }
                    return description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        if (nColumn == 0) {
            return false;
        }
        return this.m_bCellEditable;
    }

    public void setCellEditable(boolean bEditable) {
        this.m_bCellEditable = bEditable;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null || nRowIndex >= this.m_rowData.size()) {
                return;
            }
            Contact oContact = (Contact)this.m_rowData.elementAt(nRowIndex);
            if (oContact == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    oContact.setPersonName(new PersonName((String)aValue));
                    this.m_bHasChanged = true;
                    if (this.m_vwBusinessItem != null) {
                        this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                    }
                    this.BusinessChanged(1);
                    break;
                }
                case 2: {
                    oContact.setUseType((String)aValue);
                    this.m_bHasChanged = true;
                    if (this.m_vwBusinessItem != null) {
                        this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                    }
                    this.BusinessChanged(1);
                    break;
                }
                case 3: {
                    Vector<Description> v = new Vector<Description>();
                    v.add(new Description((String)aValue));
                    oContact.setDescriptionVector(v);
                    this.m_bHasChanged = true;
                    if (this.m_vwBusinessItem != null) {
                        this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                    }
                    this.BusinessChanged(1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean verifyContacts() {
        boolean bSuccess = true;
        if (this.m_rowData != null) {
            int sz = this.m_rowData.size();
            for (int i = sz - 1; i >= 0; --i) {
                Contact contactItem = (Contact)this.m_rowData.elementAt(i);
                PersonName contacter = contactItem.getPersonName();
                if (contacter != null && contacter.getValue() != null && contacter.getValue().length() >= 1) continue;
                if ((contactItem.getDescriptionVector() == null || contactItem.getDescriptionVector().size() == 0) && contactItem.getUseType() == null) {
                    this.removeRow(i);
                    continue;
                }
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_invalidContactNameInRow.toString(String.valueOf(i + 1)), VWResource.s_errorMessage, 1);
                bSuccess = false;
            }
        }
        return bSuccess;
    }

    public void releaseResources() {
        this.m_dialogTitle = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWUDDIBusinessStatusListener.class, (IVWUDDIBusinessStatusListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
    }

    public void up(int rowIndex) {
        try {
            if (rowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex - 1);
                this.m_rowData.setElementAt(currentObj, rowIndex - 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int rowIndex) {
        try {
            if (rowIndex < this.getRowCount() - 1) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex + 1);
                this.m_rowData.setElementAt(currentObj, rowIndex + 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            Contact rowItem = (Contact)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void delete(int rowIndex) {
        try {
            if (rowIndex >= 0 && rowIndex < this.m_rowData.size()) {
                this.m_rowData.removeElementAt(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
                this.m_bHasChanged = true;
                if (this.m_vwBusinessItem != null) {
                    this.m_vwBusinessItem.setModified(this.m_bHasChanged);
                }
                this.BusinessChanged(1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String checkDuplicateName(String uddiName, int row) {
        String msg = null;
        if (uddiName == null || uddiName.trim().length() < 1) {
            msg = VWResource.s_missingBusinessNameInRow.toString(String.valueOf(row + 1));
            return msg;
        }
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            VWUDDIRegistry uddiReg = (VWUDDIRegistry)this.m_rowData.elementAt(i);
            String urName = uddiReg.getName();
            if (urName == null || urName.length() < 1) {
                msg = VWResource.s_missingBusinessNameInRow.toString(String.valueOf(i + 1));
                break;
            }
            if (uddiName.compareTo(urName) != 0) continue;
            msg = VWResource.s_duplicatedContactNameInRow.toString(uddiName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }

    private void BusinessChanged(int evtType) {
        Object[] listeners = this.m_listenerList.getListenerList();
        VWUDDIBusinessStatusEvent evt = new VWUDDIBusinessStatusEvent(this, this.m_vwBusinessItem, evtType);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWUDDIBusinessStatusListener.class) continue;
            ((IVWUDDIBusinessStatusListener)listeners[i + 1]).businessChanged(evt);
        }
    }
}

